from django.conf import settings
from django.contrib import admin

from travel.marketing.content.admin.www.models import (Attraction, City, Country, Image, Landing,
                                                       Region, SeoPage, Settlement)

common_fieldsets = (
    ('SEO', {'fields': ('slug', 'title', 'seo_description')}),
    ('Twitter', {'fields': ('twitter_title', 'twitter_description', 'twitter_image')}),
    ('Open Graph', {'fields': ('og_title', 'og_description', 'og_image')})
)


class AttractionAdmin(admin.ModelAdmin):
    autocomplete_fields = ['city']
    fieldsets = ((None, {'fields': ('city', 'name', 'image', 'majority', 'description', 'preview_text')}),) + \
                common_fieldsets

    list_display = ('name', 'title', 'slug', 'city')
    list_filter = ['name', 'title', 'slug', 'city']
    save_on_top = True


admin.site.register(Attraction, AttractionAdmin)


class CityAdmin(admin.ModelAdmin):
    autocomplete_fields = ['settlement']
    fieldsets = ((None, {
        'fields': ('settlement', 'name', 'image', 'avatars_image', 'info_box', 'description'),
        "classes": ("wide", 'extrapretty')}),) + common_fieldsets

    search_fields = ['title', 'name', 'slug']
    list_display = ('name', 'title', 'slug', 'settlement')
    list_filter = ['name', 'title', 'slug']
    save_on_top = True


admin.site.register(City, CityAdmin)


class LandingAdmin(admin.ModelAdmin):
    fieldsets = ((None, {'fields': ('name', 'image', 'description')}),) + common_fieldsets
    list_display = ('name', 'title', 'slug')
    list_filter = ['name', 'title', 'slug']
    save_on_top = True


admin.site.register(Landing, LandingAdmin)


class SeoPageAdmin(admin.ModelAdmin):
    autocomplete_fields = ['parent']
    fieldsets = ((None, {'fields': ('name', 'image', 'description', 'parent', 'use_navigation')}),) + common_fieldsets
    list_display = ('name', 'title', 'slug', 'parent')
    list_filter = ['name', 'title', 'slug']
    search_fields = ['name', 'title', 'slug']
    save_on_top = True


admin.site.register(SeoPage, SeoPageAdmin)


class DebugOnlyModel(admin.ModelAdmin):
    def get_queryset(self, request):
        return super().get_queryset(request).filter(hidden=False)

    if not settings.DEBUG:
        # даем возможность создавать/менять города только под дебагом
        def get_model_perms(self, request):
            return {}


class SettlementAdmin(DebugOnlyModel):
    search_fields = ['title', 'slug']
    list_display = ('title', 'slug', 'country', 'hidden')


admin.site.register(Settlement, SettlementAdmin)


class CountryAdmin(DebugOnlyModel):
    search_fields = ['title']
    list_display = ('title', 'hidden')


admin.site.register(Country, CountryAdmin)


class RegionAdmin(DebugOnlyModel):
    list_display = ('title', 'hidden')


admin.site.register(Region, RegionAdmin)


class ImageAdmin(DebugOnlyModel):
    readonly_fields = ('width', 'height')
    save_on_top = True


admin.site.register(Image)
