# Generated by Django 3.1.4 on 2020-12-21 13:34

import django.core.files.storage
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('title', models.CharField(db_index=True, max_length=100, verbose_name='наименование')),
                ('hidden', models.BooleanField(default=False, verbose_name='скрывать')),
            ],
            options={
                'verbose_name': 'Страна',
                'verbose_name_plural': 'Страны',
                'db_table': 'www_dict_country',
            },
        ),
        migrations.CreateModel(
            name='Image',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('source', models.ImageField(height_field='height', storage=django.core.files.storage.FileSystemStorage(), upload_to='img/common', verbose_name='изображение', width_field='width')),
                ('width', models.IntegerField(editable=False, verbose_name='ширина')),
                ('height', models.IntegerField(editable=False, verbose_name='высота')),
            ],
            options={
                'verbose_name': 'Изображение',
                'verbose_name_plural': 'Изображения',
                'db_table': 'www_images',
            },
        ),
        migrations.CreateModel(
            name='Landing',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=255, verbose_name='наименование')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('seo_description', models.TextField(verbose_name='description')),
                ('slug', models.SlugField(blank=True, help_text='Название для ссылок', max_length=100, unique=True, verbose_name='slug')),
                ('og_title', models.CharField(blank=True, max_length=255, verbose_name='og:title')),
                ('og_description', models.TextField(blank=True, verbose_name='og:description')),
                ('og_image', models.ImageField(blank=True, storage=django.core.files.storage.FileSystemStorage(), upload_to='images/og', verbose_name='og:image')),
                ('twitter_title', models.CharField(blank=True, max_length=255, verbose_name='twitter:title')),
                ('twitter_description', models.TextField(blank=True, verbose_name='twitter:description')),
                ('twitter_image', models.ImageField(blank=True, storage=django.core.files.storage.FileSystemStorage(), upload_to='images/twitter', verbose_name='twitter:image')),
                ('image', models.ImageField(storage=django.core.files.storage.FileSystemStorage(), upload_to='img/content', verbose_name='изображение')),
                ('description', models.TextField(verbose_name='описание')),
            ],
            options={
                'verbose_name': 'Страница контентного лендинга',
                'verbose_name_plural': 'Страницы контентного лендинга',
                'db_table': 'www_landing',
            },
        ),
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('title', models.CharField(db_index=True, max_length=100, verbose_name='наименование')),
                ('hidden', models.BooleanField(default=False, verbose_name='скрывать')),
            ],
            options={
                'verbose_name': 'Регион',
                'verbose_name_plural': 'Регионы',
                'db_table': 'www_dict_region',
            },
        ),
        migrations.CreateModel(
            name='Settlement',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('title', models.CharField(max_length=100, verbose_name='наименование')),
                ('slug', models.SlugField(max_length=100, verbose_name='Название для ссылок')),
                ('hidden', models.BooleanField(default=False, verbose_name='скрывать')),
                ('country', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='www.country', verbose_name='страна')),
                ('region', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='www.region', verbose_name='регион')),
            ],
            options={
                'verbose_name': 'Город',
                'verbose_name_plural': 'Города',
                'db_table': 'www_dict_settlement',
            },
        ),
        migrations.CreateModel(
            name='SeoPage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=255, verbose_name='наименование')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('seo_description', models.TextField(verbose_name='description')),
                ('slug', models.SlugField(blank=True, help_text='Название для ссылок', max_length=100, unique=True, verbose_name='slug')),
                ('og_title', models.CharField(blank=True, max_length=255, verbose_name='og:title')),
                ('og_description', models.TextField(blank=True, verbose_name='og:description')),
                ('og_image', models.ImageField(blank=True, storage=django.core.files.storage.FileSystemStorage(), upload_to='images/og', verbose_name='og:image')),
                ('twitter_title', models.CharField(blank=True, max_length=255, verbose_name='twitter:title')),
                ('twitter_description', models.TextField(blank=True, verbose_name='twitter:description')),
                ('twitter_image', models.ImageField(blank=True, storage=django.core.files.storage.FileSystemStorage(), upload_to='images/twitter', verbose_name='twitter:image')),
                ('image', models.ImageField(storage=django.core.files.storage.FileSystemStorage(), upload_to='img/content', verbose_name='изображение')),
                ('description', models.TextField(verbose_name='описание')),
                ('use_navigation', models.BooleanField(verbose_name='использовать h2 как навигацию')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='www.seopage', verbose_name='Родительская страница')),
            ],
            options={
                'verbose_name': 'Страница SEO справочника',
                'verbose_name_plural': 'Страницы SEO справочника',
                'db_table': 'www_seo',
            },
        ),
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=255, verbose_name='наименование')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('seo_description', models.TextField(verbose_name='description')),
                ('slug', models.SlugField(blank=True, help_text='Название для ссылок', max_length=100, unique=True, verbose_name='slug')),
                ('og_title', models.CharField(blank=True, max_length=255, verbose_name='og:title')),
                ('og_description', models.TextField(blank=True, verbose_name='og:description')),
                ('og_image', models.ImageField(blank=True, storage=django.core.files.storage.FileSystemStorage(), upload_to='images/og', verbose_name='og:image')),
                ('twitter_title', models.CharField(blank=True, max_length=255, verbose_name='twitter:title')),
                ('twitter_description', models.TextField(blank=True, verbose_name='twitter:description')),
                ('twitter_image', models.ImageField(blank=True, storage=django.core.files.storage.FileSystemStorage(), upload_to='images/twitter', verbose_name='twitter:image')),
                ('info_box', models.TextField(verbose_name='информационный блок')),
                ('image', models.ImageField(storage=django.core.files.storage.FileSystemStorage(), upload_to='img/city', verbose_name='изображение')),
                ('description', models.TextField(verbose_name='описание')),
                ('settlement', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='www.settlement', verbose_name='город')),
            ],
            options={
                'verbose_name': 'Страница города',
                'verbose_name_plural': 'Страницы города',
                'db_table': 'www_city',
            },
        ),
        migrations.CreateModel(
            name='Attraction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=255, verbose_name='наименование')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('seo_description', models.TextField(verbose_name='description')),
                ('slug', models.SlugField(blank=True, help_text='Название для ссылок', max_length=100, unique=True, verbose_name='slug')),
                ('og_title', models.CharField(blank=True, max_length=255, verbose_name='og:title')),
                ('og_description', models.TextField(blank=True, verbose_name='og:description')),
                ('og_image', models.ImageField(blank=True, storage=django.core.files.storage.FileSystemStorage(), upload_to='images/og', verbose_name='og:image')),
                ('twitter_title', models.CharField(blank=True, max_length=255, verbose_name='twitter:title')),
                ('twitter_description', models.TextField(blank=True, verbose_name='twitter:description')),
                ('twitter_image', models.ImageField(blank=True, storage=django.core.files.storage.FileSystemStorage(), upload_to='images/twitter', verbose_name='twitter:image')),
                ('image', models.ImageField(storage=django.core.files.storage.FileSystemStorage(), upload_to='img/attraction', verbose_name='изображение')),
                ('description', models.TextField(verbose_name='описание')),
                ('majority', models.IntegerField(verbose_name='приоритет внутри города')),
                ('preview_text', models.CharField(max_length=120, verbose_name='текст для превью карусели')),
                ('city', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='www.city', verbose_name='город')),
            ],
            options={
                'verbose_name': 'Страица достопримечательности',
                'verbose_name_plural': 'Страницы достопримечательностей',
                'db_table': 'www_attractions',
            },
        ),
    ]
