PY3_LIBRARY()

OWNER(g:rasp-back)

PEERDIR(
    contrib/python/boto3
    contrib/python/django/django-3
    contrib/python/django-debug-toolbar
    contrib/python/django-storages
    contrib/python/python-json-logger
    contrib/python/Pillow
    contrib/python/python-slugify

    library/python/django
    library/python/django-idm-api
    library/python/django_pgaas
    library/python/gunicorn
    library/python/python-django-yauth
    library/python/yenv
    library/python/ylog

    travel/library/python/avia_mdb_replica_info
    travel/library/python/dicts
    travel/library/python/rasp_vault
    travel/avia/library/python/avatars
)

PY_SRCS(
    app.py
    docker/local_settings.py
    gunicorn_conf.py
    settings.py
    urls.py
    wsgi.py

    admin/admin.py
    admin/apps.py
    admin/connection.py
    admin/mds.py
    admin/middleware.py

    scripts/load_project.py
    scripts/local_settings.py
    scripts/update_dicts.py

    www/migrations/__init__.py
    www/migrations/0001_initial.py
    www/migrations/0002_auto_20211117_0025.py

    www/admin.py
    www/models.py
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
    bin/tests
)
