package geo

import (
	"a.yandex-team.ru/travel/marketing/content/backend/internal/pkg/mapping"
	"a.yandex-team.ru/travel/marketing/content/backend/internal/pkg/model"
	v1 "a.yandex-team.ru/travel/marketing/content/v1"
)

func MapCityContent(content *model.City) *v1.CityContent {
	return &v1.CityContent{
		Meta:        mapping.MapMetaInfo(content.Meta),
		Navigation:  mapping.MapNavigation(content.Navigation),
		Description: content.Description,
		InfoBox:     content.InfoBox,
	}
}

func MapAttractionContent(content *model.Attraction) *v1.AttractionContent {
	return &v1.AttractionContent{
		Meta:        mapping.MapMetaInfo(content.Meta),
		Navigation:  mapping.MapNavigation(content.Navigation),
		Description: content.Description,
		Majority:    content.Majority,
		PreviewText: content.PreviewText,
	}
}
