package db

import (
	"context"
	"database/sql"

	"github.com/opentracing/opentracing-go"
)

type Connection struct {
	db *sql.DB
}

func (conn *Connection) Query(ctx context.Context, query string, args ...interface{}) (*sql.Rows, error) {
	span, _ := opentracing.StartSpanFromContext(ctx, query)
	defer span.Finish()

	rows, err := conn.db.Query(query, args...)
	return rows, err
}

func (conn *Connection) QueryRow(ctx context.Context, query string, args ...interface{}) *sql.Row {
	span, _ := opentracing.StartSpanFromContext(ctx, query)
	defer span.Finish()

	row := conn.db.QueryRow(query, args...)
	return row
}
