package mapping

import (
	"a.yandex-team.ru/travel/marketing/content/backend/internal/pkg/model"
	v1 "a.yandex-team.ru/travel/marketing/content/v1"
)

func MapMetaInfo(meta model.ContentMeta) *v1.ContentMeta {
	return &v1.ContentMeta{
		Name:               meta.Name,
		Slug:               meta.Slug,
		Title:              meta.Title,
		Description:        meta.SeoDescription,
		Image:              meta.Image,
		OgTitle:            meta.OGTitle,
		OgDescription:      meta.OGDescription,
		OgImage:            meta.OGImage,
		TwitterTitle:       meta.TwitterTitle,
		TwitterDescription: meta.TwitterDescription,
		TwitterImage:       meta.TwitterImage,
	}
}

func MapNavigation(navigation model.Navigation) *v1.Navigation {
	children := make([]*v1.NavigationNode, 0, len(navigation.Children))

	for _, child := range navigation.Children {
		children = append(children, MapNavigationNode(child))
	}

	return &v1.Navigation{
		Parent:   MapNavigationNode(navigation.Parent),
		Children: children,
	}
}

func MapNavigationNode(node model.NavigationNode) *v1.NavigationNode {
	return &v1.NavigationNode{
		Slug: node.Slug,
		Name: node.Name,
	}
}
