package model

type ContentMeta struct {
	Name string
	Slug string

	Title          string
	SeoDescription string
	Image          string

	OGTitle       string
	OGDescription string
	OGImage       string

	TwitterTitle       string
	TwitterDescription string
	TwitterImage       string
}

type City struct {
	Meta         ContentMeta
	Navigation   Navigation
	InfoBox      string
	Description  string
	AvatarsImage string
}

type Attraction struct {
	Meta        ContentMeta
	Navigation  Navigation
	Description string
	Majority    int32
	PreviewText string
}

type Landing struct {
	Meta        ContentMeta
	Description string
}

type SeoContent struct {
	Meta          ContentMeta
	Description   string
	Navigation    Navigation
	UseNavigation bool
}

type NavigationNode struct {
	Slug string
	Name string
}

type Navigation struct {
	Parent   NavigationNode
	Children []NavigationNode
}
