package repository

import (
	"fmt"

	"a.yandex-team.ru/travel/marketing/content/backend/internal/app"
)

func MakeImagePath(relativePath string, s3 app.S3Config) string {
	if relativePath == "" {
		return ""
	}

	if s3.Public {
		return fmt.Sprintf("https://%s.%s/media/%s", s3.Bucket, s3.Endpoint, relativePath)
	}

	return fmt.Sprintf("https://%s/%s/media/%s", s3.Endpoint, s3.Bucket, relativePath)
}
