package repository

import (
	"context"
	"fmt"

	"a.yandex-team.ru/travel/marketing/content/backend/internal/app"
	"a.yandex-team.ru/travel/marketing/content/backend/internal/pkg/db"
	"a.yandex-team.ru/travel/marketing/content/backend/internal/pkg/model"
)

type LandingContentReader struct {
	metaReader ContentMetaReader
}

func NewLandingContentReader(s3 app.S3Config) *LandingContentReader {
	return &LandingContentReader{metaReader: *NewContentMetaReader(landingTableName, s3)}
}

const getLandingQuery = `
		select description
		from %s
		where slug = $1;
	`

func (r LandingContentReader) prepareQuery(query string) string {
	return fmt.Sprintf(query, landingTableName)
}

func (r LandingContentReader) GetLanding(ctx context.Context, conn *db.Connection, slug string) (*model.Landing, error) {
	meta, err := r.metaReader.GetContentMeta(ctx, conn, slug)
	if err != nil {
		return nil, fmt.Errorf("get meta error: %w", err)
	}

	query := r.prepareQuery(getLandingQuery)
	row := conn.QueryRow(ctx, query, slug)
	landing := new(model.Landing)
	landing.Meta = *meta

	err = row.Scan(
		&landing.Description,
	)

	if err != nil {
		return nil, fmt.Errorf("landing query error: %w", err)
	}

	return landing, nil
}
