package seo

import (
	"a.yandex-team.ru/travel/marketing/content/backend/internal/pkg/mapping"
	"a.yandex-team.ru/travel/marketing/content/backend/internal/pkg/model"
	v1 "a.yandex-team.ru/travel/marketing/content/v1"
)

func MapSeoContent(content *model.SeoContent) *v1.SeoContent {
	return &v1.SeoContent{
		Meta:            mapping.MapMetaInfo(content.Meta),
		Navigation:      mapping.MapNavigation(content.Navigation),
		Description:     content.Description,
		UseH2Navigation: content.UseNavigation,
	}
}
