package seo

import (
	"context"
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/marketing/content/backend/internal/app"
	"a.yandex-team.ru/travel/marketing/content/backend/internal/pkg/db"
	"a.yandex-team.ru/travel/marketing/content/backend/internal/pkg/repository"
	v1 "a.yandex-team.ru/travel/marketing/content/v1"
)

type Service struct {
	logger    log.Logger
	reader    repository.SeoContentReader
	dbCluster *db.Cluster
}

func NewService(l log.Logger, dbCluster *db.Cluster, s3 app.S3Config) *Service {
	return &Service{logger: l, dbCluster: dbCluster, reader: *repository.NewSeoContentReader(s3)}
}

func (s *Service) GetSeoContent(ctx context.Context, slug string) (*v1.SeoContent, error) {
	conn, err := s.dbCluster.GetReadableConnection()
	if err != nil {
		return nil, fmt.Errorf("get connection error: %w", err)
	}

	content, err := s.reader.GetSeoContent(ctx, conn, slug)
	if err != nil {
		return nil, fmt.Errorf("get seo content by slug=%s error: %w", slug, err)
	}

	return MapSeoContent(content), nil
}
