package configs

import (
	"time"

	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"
)

type TvmConfig struct {
	Enabled      bool     `config:"tvm-enabled"`
	WhiteList    []uint32 `config:"tvm-white-list"`
	SelfID       int      `config:"tvm-self-id"`
	DiskCacheDir string   `config:"tvm-disk-cache-dir"`
}

var DefaultTvmConfig = TvmConfig{
	DiskCacheDir: "/var/tmp/cache/tvm/",
}

type HooksHTTPConfig struct {
	Addr string `config:"hookshttp-addr,required"`
}

var DefaultHooksHTTPConfig = HooksHTTPConfig{
	Addr: "[::]:7000",
}

type BackgroundMetricsConfig struct {
	Addr                       string `config:"backgroundmetrics-addr,required"`
	PerfMetricsPrefix          string
	PerfMetricsRefreshInterval time.Duration
}

var DefaultMailingMetricsConfig = BackgroundMetricsConfig{
	Addr:                       "[::]:9948",
	PerfMetricsRefreshInterval: 5 * time.Second,
	PerfMetricsPrefix:          "background_perf",
}

type Config struct {
	EnvType        string `config:"yenv-type,required"`
	HTTP           httpserver.HTTPConfig
	HooksHTTP      HooksHTTPConfig
	Metrics        metricsserver.MetricsConfig
	MailingMetrics BackgroundMetricsConfig
	Logging        logging.Config
	Tvm            TvmConfig
	PG             DB
	Startrek       Startrek
	S3             S3
	Sender         Sender
}

var Cfg = Config{
	EnvType:        "development",
	HTTP:           httpserver.DefaultHTTPConfig,
	HooksHTTP:      DefaultHooksHTTPConfig,
	Metrics:        metricsserver.DefaultMetricsConfig,
	MailingMetrics: DefaultMailingMetricsConfig,
	Logging:        logging.DefaultConfig,
	Tvm:            DefaultTvmConfig,
	PG:             DefaultDB,
	Startrek:       DefaultStartrek,
	S3:             DefaultS3,
	Sender:         DefaultSender,
}
