package configs

type S3 struct {
	Endpoint       string `config:"s3-endpoint"`
	PublicEndpoint string `config:"s3-public-endpoint"`
	Region         string `config:"s3-region"`
	MaxRetries     int
	Bucket         string `config:"s3-bucket"`
	KeyPrefix      string
	ReadyFileDir   string `config:"s3-ready-files-dir"`

	// for ensuring these environment variables by confita
	AwsAccessKey string `config:"aws-access-key,required"`
	AwsSecretKey string `config:"aws-secret-key,required"`
}

var DefaultS3 = S3{
	Endpoint:       "http://s3.mds.yandex.net",
	PublicEndpoint: "http://s3.mds.yandex.net",
	Region:         "yandex",
	MaxRetries:     3,
	Bucket:         "rasp-test-bucket",
	ReadyFileDir:   "/ephemeral/data/ready",
	KeyPrefix:      "folk-contest",
}
