package configs

type Sender struct {
	URL      string `config:"sender-url"`
	Timeout  int    `config:"sender-timeout"` // milliseconds
	Account  string `config:"sender-account"`
	AuthUser string `config:"sender-auth-user"`
	Testing  string `config:"sender-testing-mode"` // true/false

	CampaignSlugConfirmed string `config:"sender-campaign-slug-confirmed"`
	CampaignSlugRejected  string `config:"sender-campaign-slug-rejected"`
}

var DefaultSender = Sender{
	URL:      "https://test.sender.yandex-team.ru",
	Timeout:  500,
	Account:  "travel",
	AuthUser: "b42cfcf21e0048b1bd3fdaf14ec726f8",
	Testing:  "true",

	CampaignSlugConfirmed: "8YR642Q3-8671",
	CampaignSlugRejected:  "8YR642Q3-8671",
}
