package configs

type Startrek struct {
	BaseURL string `config:"startrek-url"`
	Timeout int    `config:"startrek-timeout"` // milliseconds
	Token   string `config:"startrek-token,required"`
	Queue   string `config:"startrek-queue"`
	QueueNo string `config:"startrek-queueno"`
	OrgID   string `config:"startrek-org-id"`
}

var DefaultStartrek = Startrek{
	BaseURL: "https://api.tracker.yandex.net/v2",
	Timeout: 500,
	Queue:   "TESTKONKURS",
	QueueNo: "4",
	OrgID:   "4452807",
}
