package mailing

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/xerrors"
)

var (
	modulePrefix = "mailing"

	errorSyncReadyIssuesWithDB = xerrors.NewSentinel(fmt.Sprintf("%s.Controller.syncReadyIssuesWithDB", modulePrefix))
	errorSyncIssue             = xerrors.NewSentinel(fmt.Sprintf("%s.Controller.syncIssue", modulePrefix))
	errorRemoveMailingTag      = xerrors.NewSentinel(fmt.Sprintf("%s.Controller.removeMailingTag", modulePrefix))
	errorUpdateStory           = xerrors.NewSentinel(fmt.Sprintf("%s.Controller.updateStory", modulePrefix))
	errorSendMails             = xerrors.NewSentinel(fmt.Sprintf("%s.Controller.sendMails", modulePrefix))
	errorSendMail              = xerrors.NewSentinel(fmt.Sprintf("%s.Controller.sendMail", modulePrefix))

	errorNotFoundStoryKey     = xerrors.New("not found story key")
	errorUnresolvedIssue      = xerrors.New("unresolved issue")
	errorUnexpectedResolution = xerrors.New("unexpected issue resolution")
)
