package db

import (
	"context"
	"fmt"
	"time"

	"github.com/cenkalti/backoff/v4"
	"github.com/jackc/pgx/v4/pgxpool"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/travel/marketing/folk_guide_contest/internal/app/configs"
)

func NewPoolWithRetries(ctx context.Context, config *configs.DB, logger *zap.Logger) (*pgxpool.Pool, error) {
	var err error
	var pool *pgxpool.Pool
	err = backoff.RetryNotify(
		func() error {
			var clusterErr error
			pool, clusterErr = NewPool(ctx, config, logger)
			return clusterErr
		}, backoff.WithMaxRetries(backoff.NewConstantBackOff(time.Second), 3),
		func(e error, d time.Duration) {
			logger.Logger().Info(
				"Connection to database failed. Retrying",
				log.Any("duration", d),
				log.Error(e),
			)
		},
	)
	if err != nil {
		return nil, fmt.Errorf("internal.pkg.db.NewPoolWithRetries: %w", err)
	}
	return pool, nil
}
