package http

import (
	"encoding/json"
	"net/http"
)

type errorResponse struct {
	Error HTTPError `json:"error"`
}

type HTTPError struct {
	Message string `json:"message"`
}

func HandleError(err error, code int, w http.ResponseWriter) {
	w.WriteHeader(code)
	response := errorResponse{
		Error: HTTPError{
			Message: err.Error(),
		},
	}
	result, _ := json.Marshal(response)
	_, err = w.Write(result)
	if err != nil {
		panic(err)
	}
}
