package metrics

import (
	"a.yandex-team.ru/library/go/core/metrics"
	libMetrics "a.yandex-team.ru/travel/library/go/metrics"
)

type mailingRegistry struct{}

func (r mailingRegistry) getErrorCounter() metrics.Counter {
	return libMetrics.GlobalAppMetrics().GetOrCreateCounter(mailingPrefix, nil, mailingErrors)
}

func (r mailingRegistry) getUnresolvedIssuesGauge() metrics.Gauge {
	return libMetrics.GlobalAppMetrics().GetOrCreateGauge(mailingPrefix, nil, mailingUnresolvedIssues)
}

func (r mailingRegistry) AddError() {
	r.getErrorCounter().Add(1)
}

func (r mailingRegistry) SetUnresolvedIssues(value int) {
	r.getUnresolvedIssuesGauge().Set(float64(value))
}

var MailingRegistry = mailingRegistry{}
