package metrics

import (
	"a.yandex-team.ru/library/go/core/metrics"
	libMetrics "a.yandex-team.ru/travel/library/go/metrics"
)

type trackerRegistry struct{}

func (r trackerRegistry) getErrorCounter() metrics.Counter {
	return libMetrics.GlobalAppMetrics().GetOrCreateCounter(trackerPrefix, nil, trackerErrors)
}

func (r trackerRegistry) getStoriesWithoutIssues() metrics.Gauge {
	return libMetrics.GlobalAppMetrics().GetOrCreateGauge(trackerPrefix, nil, trackerStoriesWithoutIssues)
}

func (r trackerRegistry) AddError() {
	r.getErrorCounter().Add(1)
}

func (r trackerRegistry) SetStoriesWithoutIssues(value int) {
	r.getStoriesWithoutIssues().Set(float64(value))
}

var TrackerRegistry = trackerRegistry{}
