package metrics

import (
	"a.yandex-team.ru/library/go/core/metrics"
	libMetrics "a.yandex-team.ru/travel/library/go/metrics"
)

type uploaderRegistry struct{}

func (r uploaderRegistry) getQueueLength() metrics.Gauge {
	return libMetrics.GlobalAppMetrics().GetOrCreateGauge(uploaderPrefix, nil, uploaderQueueLength)
}

func (r uploaderRegistry) getErrorCounter() metrics.Counter {
	return libMetrics.GlobalAppMetrics().GetOrCreateCounter(uploaderPrefix, nil, uploaderErrors)
}

func (r uploaderRegistry) SetQueueLength(value int) {
	r.getQueueLength().Set(float64(value))
}

func (r uploaderRegistry) AddError() {
	r.getErrorCounter().Add(1)
}

var UploaderRegistry = uploaderRegistry{}
