package model

import (
	"time"
)

type StoryType int

const (
	Video StoryType = iota
	TextAndVideo
	TextAndPhoto
)

type StoryState int

const (
	Initialized StoryState = iota
	Saved
	TicketCreated
)

type Resolution int

const (
	ResolutionEmpty Resolution = iota
	ResolutionApproved
	ResolutionRejected
)

type MailingState int

const (
	MailingInitialized MailingState = iota
	MailingReady
	MailingStart
	MailingHandled
)

type Story struct {
	UID          string
	YandexUID    string
	State        StoryState
	Type         StoryType
	Email        string
	FirstName    string
	LastName     string
	Title        string
	Ticket       string // not yet implemented
	Resolution   Resolution
	MailingState MailingState
	CreatedAt    time.Time
	UpdatedAt    time.Time
	Blocks       []StoryBlock
}

type StoryBlock struct {
	ID       uint
	StoryUID string
	Text     *string
	Uploads  []StoryBlockUpload
}

type StoryBlockUpload struct {
	UploadUID string
	PublicURL string
}

type UploadStatus int

const (
	UploadInit UploadStatus = iota
	UploadUploaded
	UploadFileRemoved
	UploadError
)

type Upload struct {
	UID       string
	TusID     string
	StoryUID  string
	FileName  string
	FileType  string
	Status    UploadStatus
	CreatedAt time.Time
}
