package repository

import (
	"a.yandex-team.ru/library/go/core/xerrors"
	"fmt"
)

var (
	modulePrefix = "pkg.repository"

	tracingNewStory                = fmt.Sprintf("%s:NewStory", modulePrefix)
	tracingUpdateStory             = fmt.Sprintf("%s:UpdateStory", modulePrefix)
	tracingUpdateStoryState        = fmt.Sprintf("%s:UpdateStoryState", modulePrefix)
	tracingNewUpload               = fmt.Sprintf("%s:NewUpload", modulePrefix)
	tracingGetUploadsByTusID       = fmt.Sprintf("%s:GetUploadsByTusID", modulePrefix)
	tracingUpdateUpload            = fmt.Sprintf("%s:UpdateUpload", modulePrefix)
	tracingGetStory                = fmt.Sprintf("%s:GetStory", modulePrefix)
	tracingGetStoriesForMailing    = fmt.Sprintf("%s:GetStoriesForMailing", modulePrefix)
	tracingGetStoriesWithoutIssues = fmt.Sprintf("%s:tracingGetStoriesWithoutIssues", modulePrefix)
	tracingPopulateStoryWithBlocks = fmt.Sprintf("%s:PopulateStoryWithBlocks", modulePrefix)

	errorNewStory                = xerrors.NewSentinel(fmt.Sprintf("%s.NewStory", modulePrefix))
	errorGetStory                = xerrors.NewSentinel(fmt.Sprintf("%s.GetStory", modulePrefix))
	errorSendStory               = xerrors.NewSentinel(fmt.Sprintf("%s.SendStory", modulePrefix))
	errorNewUpload               = xerrors.NewSentinel(fmt.Sprintf("%s.NewUpload", modulePrefix))
	errorGetUploadsByTusID       = xerrors.NewSentinel(fmt.Sprintf("%s.GetUploadsByTusID", modulePrefix))
	errorUpdateUpload            = xerrors.NewSentinel(fmt.Sprintf("%s.UpdateUpload", modulePrefix))
	errorUpdateStorySTate        = xerrors.NewSentinel(fmt.Sprintf("%s.UpdateStoryState", modulePrefix))
	errorPopulateStoryWithBlocks = xerrors.NewSentinel(fmt.Sprintf("%s.PopulateStoryWithBlocks", modulePrefix))
)
