package s3

import (
	"fmt"
	"net/url"
	"path"

	"a.yandex-team.ru/travel/marketing/folk_guide_contest/internal/app/configs"
)

func MakeURL(uid string, config *configs.S3) string {
	uid = makeKey(uid, config)
	s3url, _ := url.Parse(config.PublicEndpoint)
	return fmt.Sprintf("https://%s.%s/%s", config.Bucket, s3url.Host, uid)
}

func makeKey(uid string, config *configs.S3) string {
	return path.Join(config.KeyPrefix, uid)
}
