package startrek

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/xerrors"
)

var (
	modulePrefix = "startrek"

	errorGetIssue     = xerrors.NewSentinel(fmt.Sprintf("%s.client.GetIssue", modulePrefix))
	errorPostIssue    = xerrors.NewSentinel(fmt.Sprintf("%s.client.PostIssue", modulePrefix))
	errorSearchIssues = xerrors.NewSentinel(fmt.Sprintf("%s.client.SearchIssues", modulePrefix))
	errorIssueRequest = xerrors.NewSentinel(fmt.Sprintf("%s.client.issueRequest", modulePrefix))
	errorDoRequest    = xerrors.NewSentinel(fmt.Sprintf("%s.client.doRequest", modulePrefix))

	errorControllerGetIssue         = xerrors.NewSentinel(fmt.Sprintf("%s.Controller.GetIssue", modulePrefix))
	errorControllerPostIssue        = xerrors.NewSentinel(fmt.Sprintf("%s.Controller.PostIssue", modulePrefix))
	errorControllerGetMailingIssues = xerrors.NewSentinel(fmt.Sprintf("%s.Controller.GetMailingIssues", modulePrefix))
	errorControllerRemoveMailingTag = xerrors.NewSentinel(fmt.Sprintf("%s.Controller.RemoveMailingTag", modulePrefix))

	errorBuildDesc   = xerrors.NewSentinel(fmt.Sprintf("%s.BuildDescription", modulePrefix))
	errorBuildBlocks = xerrors.NewSentinel(fmt.Sprintf("%s.buildBlocks", modulePrefix))

	ErrorNotFound  = xerrors.NewSentinel(fmt.Sprintf("%s.NotFound", modulePrefix))
	ErrorAmbiguous = xerrors.NewSentinel(fmt.Sprintf("%s.AmbiguousIssues", modulePrefix))
)
