package startrek

type ResolutionKey string

const (
	SuccessfulResolution ResolutionKey = "successful"
	DontDoResolution     ResolutionKey = "dontDo"
)

type Issue struct {
	Key         *string     `json:"key,omitempty"`
	Summary     string      `json:"summary"`
	Queue       IssueQueue  `json:"queue"`
	Description string      `json:"description"`
	Unique      string      `json:"unique"`
	Tags        []string    `json:"tags"`
	Resolution  *Resolution `json:"resolution,omitempty"`
}

type IssueQueue struct {
	ID string `json:"id"`
}

type Resolution struct {
	Key ResolutionKey `json:"key"`
}

func IsResolvedIssue(issue Issue) bool {
	if issue.Resolution == nil {
		return false
	}
	key := issue.Resolution.Key
	return key == DontDoResolution || key == SuccessfulResolution
}
