package tvmapi

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmauth"
	"a.yandex-team.ru/travel/marketing/folk_guide_contest/internal/app/configs"
)

func NewAPIClient(config configs.TvmConfig, logger log.Logger) (client tvm.Client, err error) {
	env := tvm.BlackboxProd
	client, err = tvmauth.NewAPIClient(
		tvmauth.TvmAPISettings{
			SelfID:                      tvm.ClientID(config.SelfID),
			EnableServiceTicketChecking: true,
			BlackboxEnv:                 &env,
			DiskCacheDir:                config.DiskCacheDir,
		},
		logger,
	)
	if err != nil {
		return nil, fmt.Errorf("pkg.tvm.NewTVMClient: %w", err)
	}
	return
}
