package handler

import (
	"github.com/go-chi/chi/v5"
	"github.com/jackc/pgx/v4/pgxpool"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/marketing/folk_guide_contest/internal/app/configs"
	"a.yandex-team.ru/travel/marketing/folk_guide_contest/internal/pkg/repository"
)

type HTTPStoriesHandler struct {
	config     *configs.Config
	pool       *pgxpool.Pool
	repository *repository.StoryRepository
	logger     log.Logger
}

func NewHTTPStoriesHandler(
	config *configs.Config,
	pool *pgxpool.Pool,
	r *repository.StoryRepository,
	l log.Logger,
) *HTTPStoriesHandler {
	return &HTTPStoriesHandler{
		config:     config,
		pool:       pool,
		repository: r,
		logger:     l,
	}
}

func (h *HTTPStoriesHandler) GetRouteBuilder() func(r chi.Router) {
	return func(r chi.Router) {
		r.Post("/new-story", h.NewStory)
		r.Post("/send-story", h.SendStory)
	}
}
