-- drop table if exists story_block;
-- drop table if exists upload;
-- drop table if exists  story;

create table if not exists story (
    id varchar(36) not null
        constraint story_pk primary key,
    yandex_uid varchar not null,
    state smallint not null,
    story_type smallint not null,
    title varchar(255) not null,
    email varchar(255) not null,
    first_name varchar(255) not null,
    last_name varchar(255) not null,
    created_at timestamp not null,
    updated_at timestamp not null,
    ticket varchar(50) not null
);

create table if not exists upload (
    id varchar(36) not null
        constraint upload_pk primary key,
    tus_id varchar not null,
    story_id varchar(36) not null
        constraint upload_story_id_fk
            references story,
    file_name varchar(255) not null,
    file_type varchar(255) not null,

    status smallint not null,

    created_at timestamp not null
);
create unique index if not exists upload_tus_id_uk
    on upload (tus_id);

create table if not exists story_block (
    id serial not null
        constraint story_block_pk primary key,
    story_id varchar(36) not null
        constraint story_block_story_id_fk
            references story,
    text varchar default null,
    upload_id varchar(36) default null
        constraint story_block_upload_id_fk
            references upload
);
