import logging
import sys

from argparse import ArgumentParser
from datetime import date, timedelta, timezone

from travel.library.python.tools import replace_args_from_env
from travel.marketing.tools.lototron.prize_box import PrizeBox
from travel.marketing.tools.lototron.wheel_of_fortune import WheelOfFortune


TIMEZONE = timezone(timedelta(hours=3), 'GMT+3')

EVENT_START = date.fromisoformat('2021-11-22')
EVENT_END = date.fromisoformat('2021-11-30')


def main():
    logging.basicConfig(
        level=logging.INFO,
        format="%(asctime)-15s | %(module)s | %(levelname)s | %(message)s",
        stream=sys.stdout,
    )

    parser = ArgumentParser()

    subparsers = parser.add_subparsers(dest='command')

    subparser = subparsers.add_parser('wheel_of_fortune')
    subparser.set_defaults(cls=WheelOfFortune)

    subparser.add_argument('--travel-api-url', required=True)
    subparser.add_argument('--api-tvm-secret', required=True)
    subparser.add_argument('--api-tvm-client-id', type=int, required=True)
    subparser.add_argument('--api-tvm-service-id', type=int, required=True)

    subparser.add_argument('--sender-url', required=True)
    subparser.add_argument('--sender-auth-key', required=True)
    subparser.add_argument('--sender-mail-list-slug', required=True)

    subparser.add_argument('--event-start', type=date.fromisoformat, default=EVENT_START)
    subparser.add_argument('--event-end', type=date.fromisoformat, default=EVENT_END)

    subparser.add_argument('--yt-proxy', default='hahn')
    subparser.add_argument('--yt-token', required=True)

    subparser.add_argument('--dump-path', required=True)

    subparser = subparsers.add_parser('prize_box')
    subparser.set_defaults(cls=PrizeBox)

    subparser.add_argument('--media-billing-url', required=True)
    subparser.add_argument('--billing-tvm-secret', required=True)
    subparser.add_argument('--billing-tvm-client-id', type=int, required=True)
    subparser.add_argument('--billing-tvm-service-id', type=int, required=True)

    subparser.add_argument('--billing-campaign-id', required=True)

    subparser.add_argument('--event-start', type=date.fromisoformat, default=EVENT_START)
    subparser.add_argument('--event-end', type=date.fromisoformat, default=EVENT_END)

    subparser.add_argument('--yt-proxy', default='hahn')
    subparser.add_argument('--yt-token', required=True)
    subparser.add_argument('--yql-token', required=True)

    subparser.add_argument('--results-path', required=True)

    args = parser.parse_args(replace_args_from_env())

    args.cls(args, TIMEZONE).run()


if __name__ == '__main__':
    main()
