import logging
from argparse import Namespace
from datetime import date, datetime, timezone, timedelta


class Event:

    def __init__(self, args: Namespace, now: datetime, tz: timezone):
        self.event_start = self.date_to_datetime(args.event_start, tz)
        self.event_end = self.date_to_datetime(args.event_end, tz) + timedelta(days=1)
        self.yesterday_start = self.date_to_datetime(now.date() - timedelta(days=1), tz)
        self.yesterday_end = self.date_to_datetime(now.date(), tz)
        logging.info(f'{now=}')
        logging.info(f'{self.event_start=}')
        logging.info(f'{self.event_end=}')
        logging.info(f'{self.yesterday_start=}')
        logging.info(f'{self.yesterday_end=}')

    @staticmethod
    def date_to_datetime(d: date, tz: timezone) -> datetime:
        return datetime(*d.timetuple()[:3], tzinfo=tz)
