from argparse import ArgumentParser

from travel.library.python.tools import replace_args_from_env
from travel.marketing.tools.perfluence_statistic_builder.const import Partner
from travel.marketing.tools.perfluence_statistic_builder.statistic_collector import StatisticCollector


def collect_TRAVELITM_99(collector: StatisticCollector) -> None:
    collector.collect(
        result_table='perfluence_nominal',
        promo_action='TRAVELITM-99 nominal',
        project_name='Collect nominal Perfluence promocodes statistic (old)',
        report_filename='perfluence_nominal_old_2022.xlsx',
        partner=Partner.PERFLUENCE,
    )
    collector.collect(
        result_table='perfluence_percent',
        promo_action='TRAVELITM-99 percent',
        project_name='Collect percent Perfluence promocodes statistic (old)',
        report_filename='perfluence_percent_old_2022.xlsx',
        partner=Partner.PERFLUENCE,
    )


def collect_TRAVELPROMOCODE_15(collector: StatisticCollector) -> None:
    collector.collect(
        result_table='perfluence_nominal_spring_2022',
        promo_action='TRAVELPROMOCODE-15: perfluence spring 2022 nominal',
        project_name='Collect nominal Perfluence promocodes statistic (spring 2022)',
        report_filename='perfluence_nominal_spring_2022.xlsx',
        partner=Partner.PERFLUENCE,
    )
    collector.collect(
        result_table='perfluence_percent_spring_2022',
        promo_action='TRAVELPROMOCODE-15: perfluence spring 2022 percent',
        project_name='Collect percent Perfluence promocodes statistic (spring 2022)',
        report_filename='perfluence_percent_spring_2022.xlsx',
        partner=Partner.PERFLUENCE,
    )


def collect_TRAVELPROMOCODE_18(collector: StatisticCollector) -> None:
    collector.collect(
        result_table='getblogger_spring_2022',
        promo_action='TRAVELPROMOCODE-18: GetBlogger spring 2022',
        project_name='Collect GetBlogger promocodes statistic (spring 2022)',
        report_filename='get_blogger_spring_2022.xlsx',
        partner=Partner.GET_BLOGGER,
    )


def collect_TRAVELPROMOCODE_30(collector: StatisticCollector) -> None:
    collector.collect(
        result_table='getblogger_spring_2022_wave_2',
        promo_action='TRAVELPROMOCODE-30: GetBlogger spring 2022 wave 2',
        project_name='Collect GetBlogger promocodes statistic (spring 2022, wave 2)',
        report_filename='get_blogger_spring_2022_wave_2.xlsx',
        partner=Partner.GET_BLOGGER,
    )


def collect_TRAVELPROMOCODE_31(collector: StatisticCollector) -> None:
    collector.collect(
        result_table='perfluence_spring_2022_wave_2',
        promo_action='TRAVELPROMOCODE-31: perfluence spring 2022 wave 2',
        project_name='Collect Perfluence promocodes statistic (spring 2022, wave 2)',
        report_filename='perfluence_spring_2022_wave_2.xlsx',
        partner=Partner.PERFLUENCE,
    )


def run(collector: StatisticCollector) -> None:
    collect_TRAVELITM_99(collector)
    collect_TRAVELPROMOCODE_15(collector)
    collect_TRAVELPROMOCODE_18(collector)
    collect_TRAVELPROMOCODE_30(collector)
    collect_TRAVELPROMOCODE_31(collector)


def main():
    parser = ArgumentParser()
    parser.add_argument('--yql-token', required=True)

    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yt-token', required=True)
    parser.add_argument('--yt-cpa-table', required=True)
    parser.add_argument('--yt-result-directory', required=True)

    parser.add_argument('--s3-endpoint', required=True)
    parser.add_argument('--s3-bucket', required=True)
    parser.add_argument('--s3-access_key', required=True)
    parser.add_argument('--s3-access_secret_key', required=True)
    parser.add_argument('--s3-result-directory', required=True)

    args = parser.parse_args(args=replace_args_from_env())
    run(StatisticCollector(args))


if __name__ == '__main__':
    main()
