from typing import Iterable

import openpyxl
from openpyxl.utils import get_column_letter


class Report:
    __report_fields__ = [
        'order_id_hash',
        'status',
        'created_at',
        'check_in',
        'check_out',
        'promo_codes',
        'amount_received_from_user',
        'order_amount_rub',
        'promocode_discount_amount',
        'real_amount_from_user',
    ]

    def __init__(self):
        self._wb = openpyxl.Workbook()
        self._ws = self._wb.active

    def _get_column_letter(self, column) -> str:
        return get_column_letter(self.__report_fields__.index(column) + 1)

    def _write_header(self) -> None:
        for column_index, column_name in enumerate(self.__report_fields__):
            self._ws[f'{get_column_letter(column_index+1)}1'] = column_name

    def load_orders(self, orders: Iterable[dict]) -> None:
        self._write_header()
        for row_index, order in enumerate(orders):
            for column_index, column_name in enumerate(self.__report_fields__):
                cell_index = f'{get_column_letter(column_index+1)}{row_index+2}'
                self._ws[cell_index] = order.get(column_name)

    def save(self, filename: str) -> None:
        return self._wb.save(filename)
