from os.path import join as pathjoin

from travel.hotels.lib.python3.yt.ytlib import create_client, ypath_join
from travel.hotels.lib.python3.yql import yqllib
from travel.library.python.s3_client import S3Client

from travel.marketing.tools.perfluence_statistic_builder.const import Partner, PARTNER_PREFIXES
from travel.marketing.tools.perfluence_statistic_builder.report import Report


class StatisticCollector:
    def __init__(self, args):
        self.yql_client = yqllib.create_client(token=args.yql_token, db=args.yt_proxy)
        self.yt_client = create_client(proxy=args.yt_proxy, config={'token': args.yt_token})

        self.s3_client = S3Client(
            endpoint=args.s3_endpoint,
            bucket=args.s3_bucket,
            access_key=args.s3_access_key,
            access_secret_key=args.s3_access_secret_key,
        )
        self.s3_result_directory = args.s3_result_directory

        self.cpa_table = args.yt_cpa_table
        self.result_directory = args.yt_result_directory

    def _collect_form_cpa(self, result_table_path: str, promo_action: str, project_name: str) -> None:
        yqllib.run_yql_file(
            client=self.yql_client,
            resource_name='collect_perfluence_statistic.yql',
            project_name=project_name,
            parameters={
                '$cpa_table': self.cpa_table,
                '$result_table': result_table_path,
                '$promo_action': promo_action,
            },
            sync=True,
        )

    def _write_report(self, result_table_path: str, local_report_filename: str) -> None:
        report = Report()
        report.load_orders(self.yt_client.read_table(result_table_path))
        report.save(local_report_filename)

    def _write_report_to_s3(self, local_report_filename: str, s3_report_filename: str) -> None:
        with open(local_report_filename, 'rb') as f:
            report_data = f.read()
        self.s3_client.write(pathjoin(self.s3_result_directory, s3_report_filename), report_data)

    def collect(
        self,
        result_table: str,
        promo_action: str,
        project_name: str,
        report_filename: str,
        partner: Partner
    ) -> None:
        result_table_path = ypath_join(self.result_directory, result_table)
        s3_report_filename = f'{PARTNER_PREFIXES[partner]}/{report_filename}'

        self._collect_form_cpa(result_table_path, promo_action, project_name)
        self._write_report(result_table_path, report_filename)
        self._write_report_to_s3(report_filename, s3_report_filename)
