package blocktests

import (
	"fmt"

	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

func TestBeforeDepartureBlock(block ui.BeforeDepartureBlock) error {

	if block.Type != string(ui.BlockTypeBeforeDeparture) {
		return fmt.Errorf("before departure block type is %v", block.Type)
	}

	if len(block.Title) == 0 {
		return fmt.Errorf("empty title in the before departure block")
	}

	if len(block.PartingWishes) == 0 {
		return fmt.Errorf("empty parting wishes in the before departure block")
	}

	for _, subblock := range block.SubBlocks {
		if len(subblock.Title) == 0 {
			return fmt.Errorf("empty title in the before departure sub-block")
		}
		for _, item := range subblock.Items {
			if len(item.Description) == 0 {
				return fmt.Errorf("empty description in the before departure block item: %+v", item)
			}
			err := testURL(item.Icon)
			if err != nil {
				return fmt.Errorf("icon error in the before departure block item %+v: %v", item, err.Error())
			}
		}
	}
	return nil
}
