package blocktests

import (
	"fmt"

	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

func TestCarouselBlock(block ui.CarouselBlock) error {

	if block.Type != string(ui.BlockTypeCarousel) {
		return fmt.Errorf("carousel block type is %v", block.Type)
	}

	if len(block.Title) == 0 {
		return fmt.Errorf("empty title in the carousel block")
	}

	if len(block.Subtitle) == 0 {
		return fmt.Errorf("empty subtitle in the carousel block")
	}

	if len(block.Action.Text) == 0 {
		return fmt.Errorf("empty action text in the carousel block")
	}

	err := testURL(block.Action.URL)
	if err != nil {
		return fmt.Errorf("action url error in carousel block %v: %v", block.Action.URL, err.Error())
	}

	for _, item := range block.Items {
		switch item := item.(type) {
		case ui.CommonCarouselBlockItem:
			if len(item.Description) == 0 {
				return fmt.Errorf("empty description in the carousel block item: %+v", item)
			}
			if len(item.Title) == 0 {
				return fmt.Errorf("empty title in the carousel block item: %+v", item)
			}
			err := testURL(item.URL)
			if err != nil {
				return fmt.Errorf("URL error in the carousel block item %v: %v", item.URL, err.Error())
			}
			err = testURL(item.Image)
			if err != nil {
				return fmt.Errorf("image error in the carousel block item %v: %v", item.Image, err.Error())
			}
			if len(item.Info.Icon) > 0 {
				err = testURL(item.Info.Icon)
				if err != nil {
					return fmt.Errorf("icon error in the carousel block item %v: %v", item.Info.Icon, err.Error())
				}
			}
		case ui.HotelCarouselBlockItem:
			if len(item.Title) == 0 {
				return fmt.Errorf("empty title in the hotel block item: %+v", item)
			}
			err := testURL(item.URL)
			if err != nil {
				return fmt.Errorf("URL error in the hotel block item %+v: %v", item, err.Error())
			}
			err = testURL(item.Image)
			if err != nil {
				return fmt.Errorf("image error in the hotel block item %+v: %v", item, err.Error())
			}
			if len(item.Price) == 0 {
				return fmt.Errorf("empty price in the hotel block item: %+v", item)
			}
		}
	}
	return nil
}
