package blocktests

import (
	"fmt"
	"regexp"

	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

var urlRegex = regexp.MustCompile(`\b(http|https)://[\w-./?&]+\b`)

func TestDisclaimersBlock(block ui.Disclaimers) error {

	if block.Type != string(ui.BlockTypeDisclaimers) {
		return fmt.Errorf("disclaimers block type is %v", block.Type)
	}

	for _, disclaimer := range block.Disclaimers {
		if len(disclaimer) == 0 {
			continue
		}

		for _, url := range urlRegex.FindAllString(disclaimer, -1) {
			err := testURL(url)
			if err != nil {
				return fmt.Errorf("error in the disclaimer block URL: %v, %v", url, err.Error())
			}
		}
	}

	return nil
}
