package blocktests

import (
	"fmt"

	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

func TestFooterBlock(block ui.FooterBlock) error {

	if block.Type != string(ui.BlockTypeFooter) {
		return fmt.Errorf("footer block type is %v", block.Type)
	}

	for _, item := range block.Links {
		if len(item.Text) == 0 {
			return fmt.Errorf("empty text in the footer link: %+v", item)
		}
		err := testURL(item.URL)
		if err != nil {
			return fmt.Errorf("URL error in the footer block link %+v: %v", item, err.Error())
		}
	}
	return nil
}
