package blocktests

import (
	"fmt"

	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

func TestGreetingBlock(block ui.Greeting) error {

	if block.Type != string(ui.BlockTypeGreeting) {
		return fmt.Errorf("greeting block type is %v", block.Type)
	}

	err := testURL(block.Image)
	if err != nil {
		return fmt.Errorf("error in greeting block's image: %v", err.Error())
	}

	if len(block.Title) == 0 {
		return fmt.Errorf("empty title in the greeting block")
	}

	if len(block.Text) == 0 {
		return fmt.Errorf("empty text in the greeting block")
	}

	return nil
}
