package blocktests

import (
	"fmt"

	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

func TestHeaderBlock(block *ui.Header) error {

	if block == nil {
		return fmt.Errorf("header block is nil")
	}

	if block.Type != string(ui.BlockTypeHeader) {
		return fmt.Errorf("header block type is %v", block.Type)
	}

	err := testURL(block.Logo)
	if err != nil {
		return fmt.Errorf("error in header block: %v", err.Error())
	}

	for _, link := range block.Links {
		err := testURL(link.URL)
		if err != nil {
			return fmt.Errorf("error in header block's link %v: %v", link, err.Error())
		}
		if len(link.Text) == 0 {
			return fmt.Errorf("empty link text in header block's link %v", link)
		}
	}

	return nil
}
