package blocktests

import (
	"fmt"

	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

func TestUsefulBlock(block ui.UsefulBlock) error {

	if block.Type != string(ui.BlockTypeUseful) {
		return fmt.Errorf("useful block type is %v", block.Type)
	}

	if len(block.Title) == 0 {
		return fmt.Errorf("empty title in the useful block")
	}

	for _, item := range block.Items {
		err := testURL(item.Image)
		if err != nil {
			return fmt.Errorf("image error in useful block's item %+v: %v", item, err.Error())
		}
		if len(item.Title) == 0 {
			return fmt.Errorf("empty title in the useful block item: %+v", item)
		}
		if len(item.Description) == 0 {
			return fmt.Errorf("empty description in the useful block item: %+v", item)
		}
		err = testURL(item.URL)
		if err != nil {
			return fmt.Errorf("URL error in useful block's item %+v: %v", item, err.Error())
		}
	}

	return nil
}
