package blocktests

import (
	"fmt"

	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

func TestWeatherBlock(block ui.WeatherBlock) error {

	if block.Type != string(ui.BlockTypeWeather) {
		return fmt.Errorf("weather block type is %v", block.Type)
	}

	if len(block.Title) == 0 {
		return fmt.Errorf("empty title in the weather block")
	}

	if len(block.Action.Text) == 0 {
		return fmt.Errorf("empty action text in the weather block")
	}

	err := testURL(block.Action.URL)
	if err != nil {
		return fmt.Errorf("action url error in weather block %+v: %v", block, err.Error())
	}

	for _, item := range block.Items {
		if len(item.Day) == 0 {
			return fmt.Errorf("empty day in the weather block item: %+v", item)
		}
		if len(item.Date) == 0 {
			return fmt.Errorf("empty date in the weather block item: %+v", item)
		}
		if len(item.Temperature.Day) == 0 {
			return fmt.Errorf("empty day temperature in the weather block item: %+v", item)
		}
		if len(item.Temperature.Night) == 0 {
			return fmt.Errorf("empty night temperature in the weather block item: %+v", item)
		}
		err := testURL(item.Conditions.Icon)
		if err != nil {
			return fmt.Errorf("icon error in weather block's item %+v: %v", item, err.Error())
		}
		if len(item.Conditions.Description) == 0 {
			return fmt.Errorf("empty conditions description in the weather block item: %+v", item)
		}
	}
	return nil
}
