package dispatchers

import (
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/notifier/internal/collector/orderchanges"
	"a.yandex-team.ru/travel/notifier/internal/collector/unprocessed"
	"a.yandex-team.ru/travel/orders/proto/order"
)

const defaultRetriesCount = 3

type Order struct {
	*base
	logger log.Logger
}

func NewOrder(
	logger log.Logger,
	orderChangesService *orderchanges.Service,
	unprocessedService *unprocessed.Service,
) *Order {
	return &Order{
		base:   newBase(logger, orderChangesService, unprocessedService),
		logger: logger,
	}
}

func (d *Order) Dispatch(message []byte) error {
	updateEvent := new(order.OrderUpdatedEvent)
	err := proto.Unmarshal(message, updateEvent)
	if err != nil {
		d.logger.Error("unexpected proto format", log.Binary("message", message))
		return nil
	}
	d.logger.Info(
		"got order update from travel-orders",
		log.String("orderID", updateEvent.OrderId),
		log.Time("updatedAt", updateEvent.UpdatedAt.AsTime()),
	)

	d.dispatchOrder(updateEvent.OrderId, updateEvent.UpdatedAt, defaultRetriesCount)
	return nil
}
