package dispatchers

import (
	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/notifier/internal/collector/orderchanges"
	"a.yandex-team.ru/travel/notifier/internal/collector/unprocessed"
	unprocessedproto "a.yandex-team.ru/travel/notifier/internal/collector/unprocessed/proto"
)

type UnprocessedOrders struct {
	*base
	logger log.Logger
}

func NewUnprocessedOrders(
	logger log.Logger,
	orderChangesService *orderchanges.Service,
	unprocessedService *unprocessed.Service,
) *UnprocessedOrders {
	logger = logger.WithName("collector.dispatchers.UnprocessedOrders")
	return &UnprocessedOrders{
		base:   newBase(logger, orderChangesService, unprocessedService),
		logger: logger,
	}
}

func (c *UnprocessedOrders) Dispatch(message []byte) error {
	req := new(unprocessedproto.UnprocessedOrder)
	err := proto.Unmarshal(message, req)
	if err != nil {
		c.logger.Error("unexpected proto format", log.Binary("message", message))
		return nil
	}
	c.dispatchOrder(req.GetOrderId(), req.GetCollectedAt(), req.GetRetriesLeft())
	return nil
}
