package orderchanges

import "time"

type Config struct {
	MaxRetries uint64        `config:"NOTIFIER_ORDER_CHANGES_MAX_RETRIES" yaml:"max_retries"`
	Timeout    time.Duration `config:"NOTIFIER_ORDER_CHANGES_TIMEOUT"`
	YPlannerID string        `config:"NOTIFIER_ORDER_CHANGES_Y_PLANNER_ID" yaml:"y_planner_id"`
	TvmID      uint32        `config:"NOTIFIER_ORDER_CHANGES_TVM_ID" yaml:"tvm_id"`
}

var DefaultConfig = Config{
	MaxRetries: 3,
	Timeout:    15 * time.Second,
	YPlannerID: "travel-notifier-testing.api",
}
