package orderchanges

import (
	"context"
	"time"

	"github.com/cenkalti/backoff/v4"
	"google.golang.org/grpc"

	"a.yandex-team.ru/travel/notifier/api/order/v1"
)

type Service struct {
	config Config
	client order.OrderChangesServiceClient
}

func NewService(connection *grpc.ClientConn, config Config) *Service {
	grpcClient := order.NewOrderChangesServiceClient(connection)
	return &Service{
		config: config,
		client: grpcClient,
	}
}

func (s *Service) Handle(ctx context.Context, req *order.OrderChangedReq) error {
	return backoff.Retry(
		func() error {
			ctx, cancel := context.WithTimeout(ctx, s.config.Timeout)
			defer cancel()

			_, err := s.client.OrderChanged(ctx, req)
			return err
		},
		backoff.WithContext(
			backoff.WithMaxRetries(
				backoff.NewConstantBackOff(time.Second),
				s.config.MaxRetries,
			),
			ctx,
		),
	)
}
