package unprocessed

type Config struct {
	Topic      string `config:"UNPROCESSED_ORDERS_TOPIC" yaml:"topic"`
	ProducerID string `config:"UNPROCESSED_ORDERS_PRODUCER_ID" yaml:"producer_id"`
	Endpoint   string `config:"LOGBROKER_PRODUCER_ENDPOINT" yaml:"endpoint"`
	Token      string `config:"LOGBROKER_PRODUCER_TOKEN,required" yaml:"token"`
	Mock       bool   `config:"MOCK_UNPROCESSED_ORDERS" yaml:"mock"`
}

var DefaultConfig = Config{
	Topic:      "/avia/development/notifier/unprocessed-orders",
	Endpoint:   "logbroker.yandex.net",
	ProducerID: "unprocessed-orders",
	Mock:       true,
}
