package contentadmin

import (
	"time"

	"a.yandex-team.ru/travel/library/go/contentadmin"
)

type Config struct {
	TvmID   uint32        `config:"CONTENT_ADMIN_APP_TVMID,required" yaml:"tvmid"`
	Host    string        `config:"CONTENT_ADMIN_APP_HOST,required" yaml:"host"`
	Timeout time.Duration `config:"CONTENT_ADMIN_APP_TIMEOUT" yaml:"timeout"`
}

var DefaultConfig = Config{
	Timeout: 60 * time.Second,
}

func (c *Config) ToLibConfig() contentadmin.ContentAdminConfig {
	return contentadmin.ContentAdminConfig{
		TvmID:   c.TvmID,
		Host:    c.Host,
		Timeout: c.Timeout,
	}
}
