package database

import (
	"context"

	"golang.yandex/hasql"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"

	"a.yandex-team.ru/travel/notifier/internal/models"
	"a.yandex-team.ru/travel/notifier/internal/pgclient"
)

type BetterPriceSubscriptionsRepository struct {
	pgClient *pgclient.PGClient
	debug    bool
}

func NewBetterPriceSubscriptionsRepository(pgClient *pgclient.PGClient, debug bool) *BetterPriceSubscriptionsRepository {
	return &BetterPriceSubscriptionsRepository{pgClient: pgClient, debug: debug}
}

func (r *BetterPriceSubscriptionsRepository) Upsert(ctx context.Context, subscription models.BetterPriceSubscription) error {
	return r.pgClient.ExecuteInTransaction(
		hasql.Primary,
		func(db *gorm.DB) error {
			db = db.WithContext(ctx)
			if err := db.FirstOrCreate(
				&subscription.Variant,
				models.Variant{ForwardKey: subscription.Variant.ForwardKey, BackwardKey: subscription.Variant.BackwardKey},
			).Error; err != nil {
				return err
			}
			return db.Clauses(clause.OnConflict{UpdateAll: true}).Create(&subscription).Error
		},
	)
}
