package database

import (
	"time"

	"a.yandex-team.ru/library/go/core/metrics"
)

type Config struct {
	Hosts              []string      `config:"DATABASE_HOSTS,required" yaml:"hosts"`
	Port               int           `config:"DATABASE_PORT,required" yaml:"port"`
	User               string        `config:"DATABASE_USER,required" yaml:"user"`
	Password           string        `config:"DATABASE_PASSWORD,required" yaml:"password"`
	Name               string        `config:"DATABASE_NAME,required" yaml:"name"`
	HostsUpdateTimeout time.Duration `config:"DATABASE_HOSTS_UPDATE_TIMEOUT" yaml:"hosts_update_timeout"`
}

type TransactionOptions struct {
	StatementTimeout                time.Duration
	LockTimeout                     time.Duration
	IdleInTransactionSessionTimeout time.Duration
	WaitForLock                     bool
}

var (
	DefaultConfig = Config{
		Port:               6432,
		User:               "avia",
		Name:               "notifier",
		HostsUpdateTimeout: 5 * time.Second,
	}

	latencyBuckets = metrics.MakeExponentialDurationBuckets(time.Millisecond, 1.3, 35)
)
